<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class AccountRequestModel extends CI_Model {
	
    function __construct() {
        parent::__construct();
		$this->load->database();
    }
    
    function create_request($first, $middle, $last, $ext_mail, $title, $department, $organization, $telephone, $mobile, $location, $user_org_id)
    {
    	return $this->db->query('INSERT INTO account_request (first_name,middle_name,last_name,ext_mail,title,department,organization,telephone,mobile,location,user_org_id,request_date,denied) VALUES ('.$this->db->escape($first).','.$this->db->escape($middle).','.$this->db->escape($last).','.$this->db->escape($ext_mail).','.$this->db->escape($title).','.$this->db->escape($department).','.$this->db->escape($organization).','.$this->db->escape($telephone).','.$this->db->escape($mobile).','.$this->db->escape($location).','.$this->db->escape($user_org_id).','.$this->db->escape(time()).',0)');
    }
	
	function approve_request($id) {
		return $this->db->query('UPDATE account_request SET approved_date='.$this->db->escape(time()).' WHERE id='.$this->db->escape($id));
    }
	
	function unapprove_request($id) {
		return $this->db->query('UPDATE account_request SET approved_date=NULL WHERE id='.$this->db->escape($id));
    }
	
	function deny_request($id,$justification) {
		return $this->db->query('UPDATE account_request SET justification='.$this->db->escape($justification).',denied = 1 WHERE id='.$this->db->escape($id));
    }
	
	function get_request($id)
    {
    	return $this->db->query('SELECT * FROM account_request WHERE id='.$this->db->escape($id));
    }
	
	function get_requests($type)
    {
    	if ($type == 'approved') {
    		return $this->db->query('SELECT * FROM account_request WHERE request_date IS NOT NULL AND approved_date IS NOT NULL AND denied = 0 ORDER BY approved_date DESC');
		}
    	else if ($type == 'denied') {
    		return $this->db->query('SELECT * FROM account_request WHERE request_date IS NOT NULL AND approved_date IS NULL AND denied = 1 ORDER BY request_date DESC');
		}
    	else {
    		return $this->db->query('SELECT * FROM account_request WHERE request_date IS NOT NULL AND approved_date IS NULL AND (denied IS NULL OR denied = 0) ORDER BY request_date DESC');
		}
    }
	
    public function get_requests_by_page_number($type, $start, $size){
    	
    	if ($type == 'approved') {
    		return $this->db->query('SELECT * FROM (select *, ROW_NUMBER() over (order by approved_date DESC, first_name) as row FROM account_request ' .
    			'WHERE request_date IS NOT NULL AND approved_date IS NOT NULL AND denied = 0) ' . 
    			' a WHERE row >= ' . $this->db->escape($start) . ' and row < ' . $this->db->escape($size+$start));
    	}
    	else if ($type == 'denied') {
    		return $this->db->query('SELECT * FROM (select *, ROW_NUMBER() over (order by request_date DESC, first_name) as row FROM account_request ' .
    			'WHERE request_date IS NOT NULL AND approved_date IS NULL AND denied = 1) ' . 
    			' a WHERE row >= ' . $this->db->escape($start) . ' and row < ' . $this->db->escape($size+$start));
    	}
    	else {
    		return $this->db->query('SELECT * FROM (select *, ROW_NUMBER() over (order by request_date DESC, first_name) as row FROM account_request ' . 
    			'where request_date IS NOT NULL AND approved_date IS NULL AND (denied IS NULL OR denied = 0)) ' . 
    			' a WHERE row >= ' . $this->db->escape($start) . ' and row < ' . $this->db->escape($size+$start));
    	}
    }
    
	function get_requests_size($type)
    {
    	if ($type == 'approved') {
    		return $this->db->query('SELECT COUNT(*) as count FROM account_request WHERE request_date IS NOT NULL AND approved_date IS NOT NULL AND denied = 0');
		}
    	else if ($type == 'denied') {
    		return $this->db->query('SELECT COUNT(*) as count FROM account_request WHERE request_date IS NOT NULL AND approved_date IS NULL AND denied = 1');
		}
    	else {
    		return $this->db->query('SELECT COUNT(*) as count FROM account_request WHERE request_date IS NOT NULL AND approved_date IS NULL AND (denied IS NULL OR denied = 0)');
		}
    }
    
	function request_status($org_id) {
		$query = $this->db->query('SELECT TOP(1) approved_date, denied FROM account_request WHERE user_org_id='.$this->db->escape($org_id).' ORDER BY request_date DESC');
		if($query) {
			if($query->num_rows() > 0) {
				$row = $query->row_array(0);
				if($row['denied']) { return 'Denied'; }
				if($row['approved_date'] === null) { return 'Pending'; }
				else { return 'Approved'; }
			}
			else { return 'No Requests'; }
		}
		return FALSE;
	}
	
	function get_justification($org_id, $request_id = null) {
		if(isset($request_id)) {
			$query = $this->db->query('SELECT justification FROM account_request WHERE user_org_id='.$this->db->escape($org_id).' AND id='.$this->db->escape($request_id));
		}
		else {
			$query = $this->db->query('SELECT TOP(1) justification FROM account_request WHERE user_org_id='.$this->db->escape($org_id).' ORDER BY request_date DESC');
		}
		if($query) {
			if($query->num_rows() === 1) { 
				$row = $query->row_array();
				return $row['justification'];
			}
		}
		return FALSE;
	}
	
	function get_account_request_data($org_id, $request_id = null) {
		if(isset($request_id)) {
			$query = $this->db->query('SELECT * FROM account_request WHERE user_org_id='.$this->db->escape($org_id).' AND id='.$this->db->escape($request_id));
		}
		else {
			$query = $this->db->query('SELECT TOP(1) * FROM account_request WHERE user_org_id='.$this->db->escape($org_id).' ORDER BY request_date DESC');
		}
		if($query) {
			if($query->num_rows() === 1) {
				$row = $query->row_array();
				return $row;
			}
		}
		return FALSE;
	}
	
	function get_ext_mail($org_id, $request_id = null) {
		if(isset($request_id)) {
			$query = $this->db->query('SELECT ext_mail FROM account_request WHERE user_org_id='.$this->db->escape($org_id).' AND id='.$this->db->escape($request_id));
		}
		else {
			$query = $this->db->query('SELECT TOP(1) ext_mail FROM account_request WHERE user_org_id='.$this->db->escape($org_id).' ORDER BY request_date DESC');
		}
		if($query) {
			if($query->num_rows() === 1) { 
				$row = $query->row_array();
				return $row['ext_mail'];
			}
		}
		return FALSE;
	}
	function get_ids($name){
		return  $this->db->query('SELECT id FROM account_request WHERE user_org_id like '.$this->db->escape($name));
	}
}